/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ExpressionSource;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions.Expression;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.ast.identifiers.TypeIdentifier;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.point.ExpressionContext;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.utils.ExpressionASMUtils;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NewArrayExpression
extends SimpleExpression {
    public final TypeIdentifier innerType;
    public final List<Expression> dims;
    public final int blankDims;

    public NewArrayExpression(ExpressionSource src, TypeIdentifier innerType, List<Expression> dims, int blankDims) {
        super(src);
        this.innerType = innerType;
        this.dims = dims;
        this.blankDims = blankDims;
    }

    @Override
    public boolean matches(FlowValue node2, ExpressionContext ctx) {
        if (node2.hasDecoration("mixinextras_persistent_arrayCreationInfo")) {
            return false;
        }
        Type newInnerType = this.getInnerType(node2.getInsn());
        if (newInnerType == null) {
            return false;
        }
        int newBlankDims = this.getBlankDims(node2.getInsn());
        if (newBlankDims + node2.inputCount() < this.blankDims + this.dims.size()) {
            return false;
        }
        if (!this.innerType.matches(ctx.pool, newInnerType)) {
            return false;
        }
        return NewArrayExpression.inputsMatch(node2, ctx, ctx.allowIncompleteListInputs, this.dims.toArray(new Expression[0]));
    }

    private Type getInnerType(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 189: {
                Type elementType = Type.getObjectType((String)((TypeInsnNode)insn).desc);
                return elementType.getSort() == 9 ? elementType.getElementType() : elementType;
            }
            case 188: {
                return ExpressionASMUtils.getNewArrayType((IntInsnNode)insn);
            }
            case 197: {
                return Type.getType((String)((MultiANewArrayInsnNode)insn).desc).getElementType();
            }
        }
        return null;
    }

    private int getBlankDims(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 189: {
                Type elementType = Type.getObjectType((String)((TypeInsnNode)insn).desc);
                return elementType.getSort() == 9 ? elementType.getDimensions() : 0;
            }
            case 197: {
                MultiANewArrayInsnNode newArray = (MultiANewArrayInsnNode)insn;
                return Type.getType((String)newArray.desc).getDimensions() - newArray.dims;
            }
        }
        return 0;
    }
}

